<?php
require_once '../auth/auth.php';
require_once '../config/db.php';
require_once '../includes/functions.php';

header('Content-Type: application/json');

// Enable error reporting for debugging
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Function to log debug information
function debug_log($message, $data = null) {
    $log = date('Y-m-d H:i:s') . " - " . $message;
    if ($data !== null) {
        $log .= " - Data: " . print_r($data, true);
    }
    error_log($log);
}

try {
    $product_id = isset($_GET['product_id']) ? intval($_GET['product_id']) : 0;
    $serial_number = isset($_GET['serial_number']) ? trim($_GET['serial_number']) : '';
    
    debug_log("Checking specific serial", [
        'product_id' => $product_id,
        'serial_number' => $serial_number
    ]);
    
    if ($product_id <= 0) {
        throw new Exception('Invalid product ID');
    }
    
    if (empty($serial_number)) {
        throw new Exception('No serial number provided');
    }
    
    // Check if this specific serial number is available for this product
    $stmt = $pdo->prepare("
        SELECT psn.serial_number, psn.status 
        FROM product_serial_numbers psn 
        WHERE psn.product_id = ? AND psn.serial_number = ?
    ");
    $stmt->execute([$product_id, $serial_number]);
    $serial = $stmt->fetch(PDO::FETCH_ASSOC);
    
    debug_log("Serial lookup result", $serial);
    
    if ($serial && $serial['status'] === 'available') {
        echo json_encode([
            'success' => true,
            'available' => true,
            'serial_number' => $serial_number,
            'message' => 'Serial number is available'
        ]);
    } else if ($serial && $serial['status'] === 'sold') {
        echo json_encode([
            'success' => true,
            'available' => false,
            'serial_number' => $serial_number,
            'message' => 'Serial number has already been sold'
        ]);
    } else {
        echo json_encode([
            'success' => true,
            'available' => false,
            'serial_number' => $serial_number,
            'message' => 'Serial number not found for this product'
        ]);
    }
    
} catch (Exception $e) {
    debug_log("Error checking specific serial", $e->getMessage());
    echo json_encode([
        'success' => false,
        'available' => false,
        'message' => $e->getMessage()
    ]);
} 